﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;

namespace WCF_BusinessManagerAHOBPRTests.EMIS
{
    [TestClass]
    public class InputEdipiOrIcnCreatorTests
    {
        [TestMethod()]
        public void CreateEdipi_Value_Has_Correct_Edipi_String()
        {
            var edipi = "6001010001";
            var cut = new DoDDeploymentImporter();
            InputEdipiIcn actual = InputEdipiOrIcnCreator.CreateUppercasedEdipi(edipi);
            Assert.AreEqual(edipi, actual.edipiORicnValue, "Expected '" + edipi + "' but got '" + actual.edipiORicnValue + "'");
            Assert.AreEqual(InputEdipiIcnInputType.EDIPI, actual.inputType, "Expected '" + InputEdipiIcnInputType.EDIPI.ToString() + "' but got '" + actual.inputType.ToString() + "'");
        }

        [TestMethod()]
        public void CreateEdipi_Value_Has_Correct_Edipi_InputType()
        {
            var edipi = "6001010001";
            var cut = new DoDDeploymentImporter();
            InputEdipiIcn actual = InputEdipiOrIcnCreator.CreateUppercasedEdipi(edipi);
            Assert.AreEqual(InputEdipiIcnInputType.EDIPI, actual.inputType, "Expected '" + InputEdipiIcnInputType.EDIPI.ToString() + "' but got '" + actual.inputType.ToString() + "'");
        }

    }
}
